<?

// INIT

include_once('lib/krumo/class.krumo.php');

ini_set('date.timezone', 'America/Montreal');
date_default_timezone_set('America/Montreal');
set_time_limit(120);

// CONFIG INIT

$config['applicationkey'] = '';
$config['applicationsecret'] = '';
$config['username'] = '';
$config['password'] = '';


// FUNCTIONS

function doCURL($URL = '', $post = false) {
  global $config;
  $site = $config['site'];
  $useragent = $config['useragent'];
  $CURL = curl_init();
  curl_setopt($CURL, CURLOPT_USERAGENT, $useragent);
//  curl_setopt($CURL, CURLOPT_COOKIEJAR, 'cookie/cookie.txt');
//  curl_setopt($CURL, CURLOPT_COOKIEFILE, 'cookie/cookie.txt');
  curl_setopt($CURL, CURLOPT_RETURNTRANSFER, 1);
//  curl_setopt($CURL, CURLOPT_FOLLOWLOCATION, 1);
  curl_setopt($CURL, CURLOPT_URL, $site . $URL);
  if($post !== false) {
    curl_setopt($CURL, CURLOPT_POST, 2);
    curl_setopt($CURL, CURLOPT_POSTFIELDS, $post);
  }
  $HTML = curl_exec($CURL);
  $info = curl_getinfo($CURL);
//  doKrumo($info);
  curl_close($CURL);
  return $HTML;
}

function sortColumn($a, $subkey) {
	foreach($a as $k => $v) {
		$b[$k] = strtolower($v[$subkey]);
	}
	asort($b);
	foreach($b as $key => $val) {
		$c[] = $a[$key];
	}
	return $c;
}

// CRON

krumo('[CRON]');

$now = date('Y-m-d H:i:s');
$today = date('Y-m-d');
$hour = date('H');
$minute = date('i');

// DATABASE INIT

if(is_file('database.dat')) {
  $database = unserialize(file_get_contents('database.dat'));
} else {
  $database['updatetime'] = $now;
  $database['meta'] = null;
  $database['shares'] = array();
}

// RECS INIT

if(is_file('recs.dat')) {
  $recs = unserialize(file_get_contents('recs.dat'));
} else {
  $recs['shares'] = array();
}

// TEMPO SHOW DATABASE

if(isset($_REQUEST['showdatabase'])) {
  krumo($database);
  die();
}

// TEMPO SHOW RECS

if(isset($_REQUEST['showrecs'])) {
  krumo($recs);
  die();
}

// TEMPO ZZZ

if(isset($_REQUEST['zzz'])) {
  krumo('[ZZZ]');

//  unset($database['shares']['ZEN']);
//  file_put_contents('database.dat', serialize($database));
//  unset($recs['shares']['ITTECHBUZ']);
//  file_put_contents('recs.dat', serialize($recs));

  krumo('[DONE]');
  die();
}

// TEMPO ZEROS

if(isset($_REQUEST['zeros'])) {
  krumo('[ZEROS]');
//  krumo($recs);
  foreach($recs['shares'] as $name => $share) {
//    if($share['dividend'] == 0) {
    if($share['score'] == 0) {
      krumo($share);
      unset($recs['shares'][$name]);
    }
  }
  file_put_contents('recs.dat', serialize($recs));
  krumo('[DONE]');
  die();
}

// DO PORTFOLIO UPDATE

if(isset($_REQUEST['portfolio']) OR ($hour == '07' AND count($database['shares']) == 0)) {
  krumo('[PORTFOLIO]');
  // PURGE OLD RECS
  foreach($recs['shares'] as $ticker => $share) {
    $updatetime = $share['updatetime'];
    $difference = abs(strtotime($updatetime) - strtotime($now));
    $days = $difference / (60 * 60 * 24);
    if($days > 1) {
      unset($recs['shares'][$ticker]);
    }
  }
  // UPDATE PORTFOLIO
  $shares = $database['shares'];
  $database['shares'] = array();
  $database['updatetime'] = $now;
  $pages = 1;
  for($page = 1; $page <= $pages; $page++) {
    $URL =<<< stop
https://api.empireavenue.com/portfolio/get?apikey={$config['applicationkey']}&username={$config['username']}&password={$config['password']}&page={$page}
stop;
    $output = doCURL($URL);
    $portfolioUpdate = json_decode($output);
    $database['meta'] = $portfolioUpdate->meta;
    $pages = $database['meta']->total_pages;
    foreach($portfolioUpdate->data as $item) {
      $ticker = strtoupper($item->ticker);
      $database['shares'][$ticker] = $item;
    }
    sleep(1);
  }
  // ORDER BY EARNINGS
  $shares = $database['shares'];
  $tempo = array();
  foreach($shares as $ticker => $share) {
    $tempo[] = array('earnings' => $share->yesterday_earnings, 'share' => $share);
  }
  $tempo = array_reverse(sortColumn($tempo, 'earnings'));
  $sharesOK = array();
  foreach($tempo as $share) {
    $sharesOK[strtoupper($share['share']->ticker)] = $share['share'];
  }
  $database['shares'] = $sharesOK;
  // GET e(ZEN)
  $URL =<<< stop
https://api.empireavenue.com/portfolio/get?apikey={$config['applicationkey']}&username=votvot&password=fnord&ticker=votvot
stop;
  $portfolio = json_decode(doCURL($URL));
  foreach($portfolio->data as $item) {
    $ticker = strtoupper($item->ticker);
    if($ticker == 'ZEN') {
      $database['shares'][$ticker] = $item;
    }
  }
  // GET e(ZEN) DIVS
  $name = 'ZEN';
  $ticker = $database['shares']['ZEN'];
  $URL =<<< stop
https://api.empireavenue.com/history/dividends/received?apikey={$config['applicationkey']}&username=votvot&password=fnord&ticker=ZEN
stop;
  $output = doCURL($URL);
  $dividends = json_decode($output);
  if(!$dividends->error) {
    $number = $ticker->shares;
    $price = $ticker->last_trade;
    $dividendDate = $dividends->data[0]->date;
    if($dividendDate == $today) {
      $dividend = $dividends->data[0]->dividend;
      $yield = $dividend / $number / $price;
    } else {
      $dividend = 0;
      $yield = 0;
    }
    $score = floor($yield * 10000);
    $item = array();
    $item['updatetime'] = $now;
    $item['name'] = $name;
    $item['fullname'] = $ticker->full_name;
    $item['image'] = $ticker->sm_portrait;
    $item['dividend'] = $dividend;
    $item['number'] = $number;
    $item['price'] = $price;
    $item['yield'] = $yield;
    $item['score'] = $score;
    $recs['shares'][$name] = $item;
  }
  unset($database['shares'][$name]);
}

// DO SHARES

//if(isset($_REQUEST['shares'])) {
if(true) {
  $amount = 10;
  krumo('[SHARES]');
  $database['updatetime'] = $now;
  $shares = $database['shares'];
  $cursor = 0;
  $max = $cursor + $amount;
  foreach($shares as $name => $ticker) {
    krumo($ticker);
    $URL =<<< stop
https://api.empireavenue.com/history/dividends/received?apikey={$config['applicationkey']}&username={$config['username']}&password={$config['password']}&ticker={$name}
stop;
    $output = doCURL($URL);
    $dividends = json_decode($output);
    if(!$dividends->error) {
      $number = $ticker->shares;
      $price = $ticker->last_trade;
      $dividendDate = $dividends->data[0]->date;
      if($dividendDate == $today) {
        $dividend = $dividends->data[0]->dividend;
        $yield = $dividend / $number / $price;
      } else {
        $dividend = 0;
        $yield = 0;
      }
      $score = floor($yield * 10000);
      $item = array();
      $item['updatetime'] = $now;
      $item['name'] = $name;
      $item['fullname'] = $ticker->full_name;
      $item['image'] = $ticker->sm_portrait;
      $item['dividend'] = $dividend;
      $item['number'] = $number;
      $item['price'] = $price;
      $item['yield'] = $yield;
      $item['score'] = $score;
      $recs['shares'][$name] = $item;
      $share = array_shift($shares);
    }
    $count++;
    if($count >= $amount) break;
    sleep(1);
  }
  $database['shares'] = $shares;
}

// SAVE
//krumo($config);
//file_put_contents('config.dat', serialize($config));
//krumo($database);
file_put_contents('database.dat', serialize($database));
//krumo($recs);
file_put_contents('recs.dat', serialize($recs));

krumo('[DONE]');

die();

?>